/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.formatter;

import de.willuhn.jameica.gui.formatter.Formatter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class CurrencyFormatter
implements Formatter {
    private DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
    private String curr = "";

    public CurrencyFormatter(String currencyName, DecimalFormat formatter) {
        if (currencyName != null) {
            this.curr = currencyName;
        }
        if (formatter == null) {
            this.formatter.applyPattern("#0.00");
        } else {
            this.formatter = formatter;
        }
    }

    @Override
    public String format(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Number) {
            double d = ((Number)o).doubleValue();
            if (this.formatter.getMaximumFractionDigits() == 2 && Math.abs(d) < 0.01) {
                d = 0.0;
            }
            return this.formatter.format(d) + " " + this.curr;
        }
        return o.toString() + " " + this.curr;
    }
}

